<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ApiRestaurantModel;

class ApiRestaurant extends BaseController
{
    public function index()
    {
        $data = [
            'title' => 'API do restaurante',
            'page' => 'API do restaurante'
        ];

        // get information from the restaurant api data
        $model = new ApiRestaurantModel();
        $id_restaurant = session('user')['id_restaurant'];
        $results = $model->select(
                            [
                                'project_id', 
                                'api_key_openssl'
                            ])->where('id', $id_restaurant)->first();

        $data['project_id'] = $results->project_id;
        $data['api_key_openssl'] = Decrypt($results->api_key_openssl);

        // get list of all cigrequest machines operating for this restaurant
        $data['cigrequest_machines'] = $model->get_machines_from_restaurant($id_restaurant);

        return view('dashboard/api_restaurant/index', $data);
    }

    public function download($enc_machine_id)
    {
        // decrypt the machine id
        $machine_id = Decrypt($enc_machine_id);
        
        if(empty($machine_id)){
            return redirect()->to('/api_restaurant');
        }

        $model = new ApiRestaurantModel();
        $id_restaurant = session('user')['id_restaurant'];
        $results = $model->select('project_id, api_key_openssl')
                         ->where('id', $id_restaurant)
                         ->first();

        if(empty($results)){
            return redirect()->to('/api_restaurant');
        }

        // prepare config.json data
        $data['api_url'] = base_url() . 'api/';
        $data['project_id'] = $results->project_id;
        $data['api_key'] = Decrypt($results->api_key_openssl);
        $data['machine_id'] = $machine_id;

        // download the file without escaping the data
        return $this->response->download('config.json', json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
    }

    public function create_new_machine()
    {
        // get restaurant project_id and api_key
        $id_restaurant = session('user')['id_restaurant'];
        $model = new ApiRestaurantModel();
        $results = $model->select('project_id, api_key_openssl')
                         ->where('id', $id_restaurant)
                         ->first();

        // decrypt the api_key
        $api_key = Decrypt($results->api_key_openssl);

        // create a new machine_id
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $machine_id = substr(str_shuffle($chars), 0, 8);

        // download the file
        return $this->response->download('config.json', json_encode([
            'api_url' => base_url() . 'api/',
            'project_id' => $results->project_id,
            'api_key' => $api_key,
            'machine_id' => $machine_id
        ], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
    }

    public function change_api_key()
    {
        // change the api key for the restaurant
        $id_restaurant = session('user')['id_restaurant'];

        // create a new api key
        $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $chars = $chars.$chars.$chars;
        $api_key = substr(str_shuffle($chars), 0, 32);

        // update the api key
        $model = new ApiRestaurantModel();
        $model->update($id_restaurant, [
            'api_key' => password_hash($api_key, PASSWORD_DEFAULT),
            'api_key_openssl' => Encrypt($api_key),
            'updated_at' => date('Y-m-d H:i:s')
        ]);

        // redirect to the api restaurant page
        return redirect()->to('/api_restaurant');
    }
}
