<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class UpdateOrdersTable extends Migration
{
    public function up()
    {
        // add columns
        $this->forge->addColumn('orders', [
            'machine_id' => [
                'type' => 'varchar',
                'constraint' => 50,
                'null' => true,
                'after' => 'id_restaurant'
            ],
            'total_price' => [
                'type' => 'decimal',
                'constraint' => '10,2',
                'null' => true,
                'after' => 'order_status'
            ],
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('orders', ['machine_id', 'total_price']);
    }
}
