<?php

namespace App\Database\Seeds;

use App\Models\RestaurantModel;
use App\Models\UserModel;
use CodeIgniter\Database\Seeder;

class NewRestaurantSeeder extends Seeder
{
    public function run()
    {
        $this->_output_start_process();

        $json_file = APPPATH . 'Database/Seeds/new.json';
        
        // check if the new.json file exists
        $this->_check_json_file($json_file);

        // check json file content
        $this->_check_json_file_content($json_file);

        // get data from json file
        $content = json_decode(file_get_contents($json_file), true);

        // add restaurant to the database
        $this->_insert_restaurant($content['restaurant']);
        
        // add admin data to database
        $this->_insert_admin($content['admin']);

        $this->_output_end_process();
    }

    private function _insert_restaurant($restaurant)
    {
        // load encrypt helper
        helper('encryption');

        $restaurant_model = new RestaurantModel();
        $data = [
            'name' => $restaurant['name'],
            'address' => $restaurant['address'],
            'phone' => $restaurant['phone'],
            'email' => $restaurant['email'],
            'project_id' => $restaurant['project_id'],
            'api_key' => password_hash($restaurant['api_key'], PASSWORD_DEFAULT),
            'api_key_openssl' => Encrypt($restaurant['api_key']),
            'created_at' => date('Y-m-d H:i:s')
        ];
        $restaurant_model->insert($data);
    }

    private function _insert_admin($admin)
    {
        $user_model = new UserModel();
        $data = [
            'id_restaurant' => $admin['id_restaurant'],
            'username' => $admin['username'],
            'passwrd' => password_hash($admin['password'], PASSWORD_DEFAULT),
            'name' => $admin['name'],
            'email' => $admin['email'],
            'phone' => $admin['phone'],
            'roles' => json_encode($admin['roles']),
            'active' => 1,
            'created_at' => date('Y-m-d H:i:s')
        ];
        $user_model->insert($data);
    }

    private function _check_json_file($json_file)
    {
        if(!file_exists($json_file)){
            $this->_output_error("Arquivo new.json não encontrado.");
            $this->_output_end_process();
            exit;
        }
    }

    private function _check_json_file_content($json_file)
    {
        $json_content = file_get_contents($json_file);
        $json_data = json_decode($json_content, true);

        // check for restaurant key
        if(!key_exists('restaurant', $json_data)){
            $this->_output_error("Arquivo new.json não possui a chave 'restaurant'");
            $this->_output_end_process();
            exit;
        }

        // check for admin key
        if(!key_exists('admin', $json_data)){
            $this->_output_error("Arquivo new.json não possui a chave 'admin'");
            $this->_output_end_process();
            exit;
        }

        // other checks
        // ....
    }

    private function _output_start_process()
    {
        echo PHP_EOL;
        echo str_repeat('-', 50) . PHP_EOL;
        echo "Início do processo de criação de novo restaurante" . PHP_EOL;
        echo str_repeat('-', 50) . PHP_EOL;
    }

    private function _output_error($message)
    {
        echo "Erro: $message" . PHP_EOL;
    }

    private function _output_end_process()
    {
        echo PHP_EOL;
        echo str_repeat('-', 50) . PHP_EOL;
        echo "Fim do processo de criação de novo restaurante" . PHP_EOL;
        echo str_repeat('-', 50) . PHP_EOL;
        echo PHP_EOL;
    }
}
