<?php

namespace App\Models;

use CodeIgniter\Model;

class ApiRestaurantModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'restaurants';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'api_key',
        'api_key_openssl',
        'updated_at'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function get_machines_from_restaurant($id_restaurant)
    {
        // get all distinct machines from orders table
        return $this->db->table('orders')
                        ->select('machine_id')
                        ->distinct()
                        ->where('id_restaurant', $id_restaurant)
                        ->where('deleted_at', null)
                        ->get()->getResult();
    }
}
