<?php

// define the namespace
namespace App\Routes;

// allows access to service routes
use Config\Services;

// set the routes collection
$routes = Services::routes();

// api routes
$routes->get('/api/get_status',                 'Api::api_status');
$routes->get('/api/get_restaurant_details',     'Api::get_restaurant_details');
$routes->post('/api/request_checkout',          'Api::request_checkout');
$routes->post('/api/request_final_confirmation','Api::request_final_confirmation');
$routes->get('/api/get_pending_orders',         'Api::get_pending_orders');

// delete order
$routes->post('/api/get_order_details',         'Api::get_order_details');
$routes->post('/api/delete_order',              'Api::delete_order');
$routes->post('/api/get_order_details_with_products', 'Api::get_order_details_with_products');

// finish order
$routes->post('/api/finish_order',              'Api::finish_order');


// api route does not exists
$routes->set404Override(function(){

    // if route is from api
    if(preg_match("/^\/api\//", uri_string())){
        response()->setContentType('application/json');
        $response = new \App\Libraries\ApiResponse();
        echo $response->set_response_error(404, 'api route does not exists');
        exit();
    }

    // other routes (cigburger_bo)
    throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();

});
