<?= $this->extend('layouts/layout_auth') ?>
<?= $this->section('content') ?>

<div class="login-box">

    <div class="text-center mb-3">
        <img src="<?= base_url('assets/images/logo.png') ?>" alt="Logo">
    </div>

    <?= form_open('/auth/forgot_password_submit') ?>
    <div class="mb-3">
        <p class="mb-2">Restaurante</p>
        <select name="select_restaurant" id="select_restaurant" class="form-select">
            <option value="">--Selecione o restaurante--</option>
            <?php foreach ($restaurants as $restaurant) : ?>
                <?php
                $selected = '';
                if (!empty($select_restaurant) && $select_restaurant == $restaurant->id) {
                    $selected = 'selected';
                }
                ?>
                <option value="<?= Encrypt($restaurant->id) ?>" <?= $selected ?>><?= $restaurant->name ?></option>
            <?php endforeach; ?>
        </select>
        <?= display_error('select_restaurant', $validation_errors) ?>
    </div>
    <hr>    
    <div class="mb-3">
        <input type="email" class="form-control" id="text_email" name="text_email" placeholder="Email" value="<?= old('text_email') ?>">
        <?= display_error('text_email', $validation_errors) ?>
    </div>
    <div class="mb-3 text-end">
        <button type="submit" class="btn-login px-4">Recuperar Senha</button>
    </div>
    <?= form_close() ?>

    <div class="my-3">
        <p class="text-center">Sabe a senha? <a href="<?= site_url('/auth/login') ?>" class="login-link">Entrar</a></p>
    </div>

</div>

<?= $this->endSection() ?>