<?= $this->extend('layouts/layout_main') ?>
<?= $this->section('content') ?>
<?= $this->include('partials/page_title') ?>

<div class="content-box">
    <h5 style="color: #0000ff;">Editar Perfil</h5> <!-- azul -->
    <hr class="my-2">
    <div class="d-flex justify-content-between ">
        <p class="mb-0">Usuário: <strong><?= $user->username ?></strong></p>
        <p class="mb-0">Perfil: <strong><?= $user->role ?></strong></p>
        <p class="mb-0">Conta criada em: <strong><?= $user->created_at ?></strong></p>
    </div>
    <hr class="mt-1 mb-3">
    <div class="row">
        <div class="col-sm-6 col-12 my-1">
            <div class="card p-4">
                <h5><i class="fa-solid fa-user-pen me-3"></i><strong>Dados do acesso</strong></h5>
                <hr class="my-2">
                <?= form_open('/auth/profile_submit') ?>
                <div class="mb-3">
                    <label for="text_name">Nome</label>
                    <input type="text" class="form-control" name="text_name" value="<?= old('text_name', $user->name) ?>">
                    <?= display_error('text_name', $validation_errors) ?>
                </div>
                <div class="mb-3">
                    <label for="text_email">E-mail</label>
                    <input type="text" class="form-control" name="text_email" value="<?= old('text_email', $user->email) ?>">
                    <?= display_error('text_email', $validation_errors) ?>
                </div>
                <div class="mb-3">
                    <label for="text_phone">Telefone</label>
                    <input type="text" class="form-control" name="text_phone" value="<?= old('text_phone', $user->phone) ?>">
                    <?= display_error('text_phone', $validation_errors) ?>
                </div>
                <hr>
                <button type="submit" class="btn btn-primary px-3"><i class="fa-solid fa-check me-2"></i>Salvar</button>
                <?= form_close() ?>

                <?php if(!empty($profile_success)) : ?>
                    <div class="alert alert-success mt-3">
                        Dados de usuário atualizados com sucesso!
                    </div>
                <?php endif; ?>

                <?php if(!empty($server_error)) : ?>
                    <div class="alert alert-danger mt-3">
                        <?= $server_error ?>
                    </div>
                <?php endif; ?>

            </div>
        </div>
        <div class="col-sm-6 col-12 my-1">
            <div class="card p-4">
                <h5><i class="fa-solid fa-key me-3"></i><strong>Alterar senha</strong></h5>
                <hr class="my-2">
                <?= form_open('/auth/change_password_submit') ?>
                <div class="mb-3">
                    <label for="text_password">Senha atual</label>
                    <input type="password" class="form-control" name="text_password">
                    <?= display_error('text_password', $validation_errors) ?>
                </div>
                <div class="mb-3">
                    <label for="text_new_password">Nova senha</label>
                    <input type="password" class="form-control" name="text_new_password">
                    <?= display_error('text_new_password', $validation_errors) ?>
                </div>
                <div class="mb-3">
                    <label for="text_new_password_confirm">Confirmar nova senha</label>
                    <input type="password" class="form-control" name="text_new_password_confirm">
                    <?= display_error('text_new_password_confirm', $validation_errors) ?>
                </div>
                <hr>
                <button type="submit" class="btn btn-success px-3"><i class="fa-solid fa-check me-2"></i>Atualizar Senha</button>
                <?= form_close() ?>

                <?php if(!empty($password_success)) : ?>
                    <div class="alert alert-success mt-3">
                        Senha atualizada com sucesso
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>