<?= $this->extend('layouts/layout_main') ?>
<?= $this->section('content') ?>
<?= $this->include('partials/page_title') ?>

<div class="content-box">
    <?= form_open_multipart('/categorias/edit_submit') ?>

    <input type="hidden" name="id_categoria" value="<?= Encrypt($categoria->id) ?>">

    <div class="row">

        <div class="col-lg-12 col-12 p-5">
            <div class="row">
                <!-- Código -->
                <div class="col-sm-2">
                    <div class="mb-3">
                        <label for="descricao" class="form-label2">Código</label>
                        <input disabled type="text" name="text_codigo" id="text_codigo" class="form-control" value="<?= old('text_codigo', $categoria->id) ?>">
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- Descricao -->
                <div class="col-sm-6">
                    <div class="mb-3">
                        <label for="descricao" class="form-label2">Descrição</label>
                        <input type="text" name="text_descricao" id="text_descricao" class="form-control" placeholder="Descrição" value="<?= old('text_descricao', $categoria->descricao) ?>">
                        <?= display_error('text_descricao', $validation_errors) ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- Descricao Inicio-->
                <div class="col-sm-6">
                    <div class="mb-3">
                        <label for="descricao" class="form-label2">Descrição apresentada no inicio da categoria no cardápio</label>
                        <input type="text" name="text_descricao_inicio" id="text_descricao_inicio" class="form-control" placeholder="Descrição" value="<?= old('text_descricao_inicio', $categoria->descricao_inicio) ?>">
                        <?= display_error('text_descricao__inicio', $validation_errors) ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- Descricao Fim-->
                <div class="col-sm-6">
                    <div class="mb-3">
                        <label for="descricao" class="form-label2">Descrição apresentada no fim da categoria no cardápio</label>
                        <input type="text" name="text_descricao_fim" id="text_descricao_fim" class="form-control" placeholder="Descrição" value="<?= old('text_descricao_fim', $categoria->descricao_fim) ?>">
                        <?= display_error('text_descricao__fim', $validation_errors) ?>
                    </div>
                </div>

            </div>
            <div class="row">
                <!-- Selecione a categoria-->
                
                <!-- Situação da Categoria -->
                <div class="col-sm-3">
                    <div class="mb-3">
                    <label for="active" class="form-label2">Ativo</label>
                        <select  name="text_active" id="text_active" class="form-control">
                              <option <?= old('text_active', $categoria->active) == 1  ? 'selected' : '' ?>>Ativo</option>
                              <option <?= old('text_active', $categoria->active) == 0  ? 'selected' : '' ?>>Inativo</option>
                        </select>
                        <?= display_error('text_active', $validation_errors) ?>
                    </div>
                </div>
                 <div class="col-sm-3">
                    <!-- Data Cadastro -->
                    <div class="mb-3">
                        <label for="cadastro" class="form-label2">Data Cadastro</label>
                        <input type="text" name="text_data_cadastro" id="text_data_cadastro" class="form-control" placeholder="Data Cadastro"  disabled  value="<?= old('text_data_cadastro', $categoria->created_at) ?>">
                        <?= display_error('text_data_cadastro', $validation_errors) ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <hr>
        </div>
        <!-- submit -->
        <div class="row">
            <div class="col px-5 pb-3 text-end">
                <a href="<?= site_url('categorias') ?>" class="btn btn-warning px-4"> <i class="fas fa-ban me-2"></i>Cancelar</a>
                <button type="submit" class="btn btn-primary px-4"><i class="fas fa-check me-2"></i>Salvar </button>
          </div>
        </div>

        <?= form_close() ?>
    </div>

    <script src="<?= base_url("assets/libs/datatables/jquery/jquery.min.js"); ?>"></script>
    <script src="<?= base_url("assets/libs/datatables/jquery/jquery.mask.min.js"); ?>"></script>
    <script src="<?= base_url("assets/libs/datatables/jquery/jquery.mask.js"); ?>"></script>
    <script src="<?= base_url("assets/libs/datatables/jquery/scripts.js"); ?>"></script>

    <?php if(!empty($server_error)) : ?>
        <div class="row">
            <div class="col">
                <div class="alert alert-danger p-2">
                    <i class="fa-solid fa-triangle-exclamation me-2"></i><?= $server_error ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

</div>


<script>
    document.addEventListener('DOMContentLoaded', () => {
        flatpickr('#text_data_cadastro', {
            dateFormat: 'd/m/Y',
            time_24hr: true,
            enableTime: false
           })
    })
</script>


<?= $this->endSection() ?>