<?= $this->extend('layouts/layout_main') ?>
<?= $this->section('content') ?>
<?= $this->include('partials/page_title') ?>

<div class="mb-3">
    <a href="<?= site_url('categorias/new') ?>" class="btn btn-primary" style="margin-left: 30px;">
        <i class="fa-solid fa-user-plus me-2"></i>Nova categoria
    </a>
</div>


<div class="container-fluid mb-5">
    <div class="row">
        <div class="col content-box p-4">

            <?php if (empty($categorias)) : ?>
                <h4 class="text-center opacity-50 my-3">Não existem categorias cadastrada</h4>
            <?php else : ?>
                <table class="table table-striped table-bordered" id="table_categorias">
                    <thead class="table-striped">
                        <tr>
                            <th style="width:10%" class="text-center">Código</th>
                            <th style="width:50%" class="text-center">Descricao</th>
                            <th style="width:10%" class="text-center">Status</th>
                            <th style="width:15%" class="text-center">Data Cadastro</th>
                            <th>Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($categorias as $categoria) : ?>
                            <tr>
                                <td><?= $categoria['id'] ?></td>
                                <td><?= $categoria['descricao'] ?></td>
                                <?php if($categoria['active']==1): ?>
                                    <td id="text_active">Ativo</td>
                                <?php else : ?>
                                    <td id="text_active">Inativo</td>
                                <?php endif; ?>
                                <td><?= $categoria['created_at'] ?></td>
                                <td class="text-center">
                                    <a href="<?= site_url('/categorias/edit/' . Encrypt($categoria['id'])) ?>" class="btn btn-sm btn-outline-primary">
                                    <i class="fa-regular fa-pen-to-square"></i>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>

        </div>
    </div>
</div>


<script>
    window.addEventListener('DOMContentLoaded', () => {

        // datatable
        $('#table_categorias').DataTable({
            pageLength: 10,
            language: {
                decimal: "",
                emptyTable: "Sem dados disponíveis na tabela.",
                info: "Mostrando _START_ até _END_ de _TOTAL_ registos",
                infoEmpty: "Mostrando 0 até 0 de 0 registos",
                infoFiltered: "(Filtrando _MAX_ total de registos)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrando _MENU_ registos por página.",
                loadingRecords: "Carregando...",
                processing: "Processando...",
                search: "Filtrar:",
                zeroRecords: "Nenhum registro encontrado.",
                paginate: {
                    first: "Primeira",
                    last: "Última",
                    next: "Seguinte",
                    previous: "Anterior"
                },
                aria: {
                    sortAscending: ": ative para classificar a coluna em ordem crescente.",
                    sortDescending: ": ative para classificar a coluna em ordem decrescente."
                }
            }
        });
    })
    window.addEventListener('load', () => {
         setTimeout(() => {
            $('#indicadorCarregando').fadeOut('slow');
         }, 300); // Espera só um pouquinho pra suavizar o efeito
    });

</script>

<?= $this->endSection() ?>