<!DOCTYPE html>
<html lang="pt">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CigBurger Backoffice - <?= !empty($title) ? $title : '' ?></title>


    
    <!-- favicon -->
    <link rel="shortcut icon" href="<?= base_url('assets/images/logo.png') ?>" type="image/png">

    <!-- bootstrap -->
    <link rel="stylesheet" href="<?= base_url('assets/libs/bootstrap/bootstrap.min.css') ?>">

    <!-- fontawesome -->
    <link rel="stylesheet" href="<?= base_url('assets/libs/fontawesome/all.min.css') ?>">

    <!-- google font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Rajdhani:wght@500;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">


    <!-- flatpickr -->
    <link rel="stylesheet" href="<?= base_url('assets/libs/flatpickr/flatpickr.min.css') ?>">

    <?php if(!empty($datatables)) : ?>
        <script src="<?= base_url('assets/libs/datatables/jquery/jquery.min.js') ?>"></script>
        <link rel="stylesheet" href="<?= base_url('assets/libs/datatables/datatables.min.css') ?>">
    <?php endif; ?>

    <!-- apexcharts -->
    <?php if(!empty($apexcharts)) : ?>
        <link rel="stylesheet" href="<?= base_url('assets/libs/apexcharts/apexcharts.css') ?>">
    <?php endif; ?>

    <!-- css -->
    <link rel="stylesheet" href="<?= base_url('assets/css/main.css') ?>">

    <style>
        body {
        font-family: 'Inter', sans-serif;
        }
    </style>


</head>

<body>

    <!-- top bar -->
    <?= $this->include('partials/top_bar.php') ?>

    <!-- main -->
    <section class="d-flex">

        <!-- main menu -->
        <nav class="main-menu p-2">
            <?= $this->include('partials/main_menu.php') ?>
        </nav>

        <!-- content -->
        <div class="content p-4 flex-fill">
            <?= $this->renderSection('content') ?>
        </div>

    </section>

    <!-- footer -->
    <?= $this->include('partials/footer.php') ?>

    <!-- boostrap -->
    <script src="<?= base_url('assets/libs/bootstrap/bootstrap.bundle.min.js') ?>"></script>

    <!-- flatpickr -->
    <script src="<?= base_url('assets/libs/flatpickr/flatpickr.min.js') ?>"></script>

    <?php if(!empty($datatables)) : ?>
        <script src="<?= base_url('assets/libs/datatables/datatables.min.js') ?>"></script>
    <?php endif; ?>

    <!-- apexcharts -->
    <?php if(!empty($apexcharts)) : ?>
        <script src="<?= base_url('assets/libs/apexcharts/apexcharts.min.js') ?>"></script>
    <?php endif; ?>

    <script>
        document.querySelector(".btn-main-menu").addEventListener("click", () => {
            document.querySelector(".main-menu").classList.toggle("show");
            document.querySelector(".content").classList.toggle("show");
        })
    </script>


</body>

</html>